#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;

vector <int> graf[300005];
int interval[600005];
int lastr[600005];
int lastl[600005];
int dist[3005];
int par[300005][20];
int son[300005][20];

const int INF = 1000000000;

int l[300005];
int r[300005];

void bfs(int root, int n){
    for(int i=1; i<=n; i++){
        dist[i] = INF;
    }
    queue <int> q;
    q.push(root);
    dist[root] = 0;
    while(!q.empty()){
        int v = q.front();
        q.pop();
        for(auto c : graf[v]){
            if(dist[c] > dist[v]+1){
                dist[c] = dist[v]+1;
                q.push(c);
            }
        }
    }
}

bool parent(int a, int b){
    return l[a] <= l[b] && r[b] <= r[a];
}

bool cikdole(int x){
    return son[par[x][0]][0] == x;
}

bool cikgore(int x){
    return par[son[x][0]][0] == x;
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

    int n, q;
    cin >> n >> q;
    if(1LL*n*q > 1e8) return 0;
    for(int i=1; i<=2*n; i++){
        cin >> interval[i];
        lastl[i] = lastl[i-1];
        if(l[interval[i]]){
            r[interval[i]] = i;
            lastl[i] = max(lastl[i], l[interval[i]]);
        }
        else{
            l[interval[i]] = i;
        }
    }
    for(int i=1; i<=2*n; i++){
        lastr[i] = lastr[i-1];
        if(l[interval[i]] == i){
            lastr[i] = max(lastr[i], r[interval[i]]);
        }
    }
    for(int i=1; i<=n; i++){
        for(int j=1; j<=n; j++){
            if(i == j) continue;
            if(l[i] <= l[j] && r[j] <= r[i]){
                graf[i].push_back(j);
                graf[j].push_back(i);
            }
        }
    }
    for(int i=1; i<=n; i++){
        /// u koga ide i ako ide u parenta?
        /// najdesnje r od 1 do l[i]-1
        if(lastr[l[i]-1] > r[i]){
            par[i][0] = interval[lastr[l[i]-1]];
        }
        /// u koga ide ako ide u sina?
        /// najdesnje l od l[i] do r[i], tj. najdesnje l od 1 do r[i]
        if(lastl[r[i]] > l[i]){
            son[i][0] = interval[lastl[r[i]]];
        }
        //cout << i << " " << par[i][0] << " " << son[i][0] << endl;
    }
    for(int i=1; i<=n; i++){
        par[i][1] = son[par[i][0]][0];
        son[i][1] = par[son[i][0]][0];
    }
    for(int j=2; j<=19; j++){
        for(int i=1; i<=n; i++){
            par[i][j] = par[par[i][j-1]][j-1];
            son[i][j] = son[son[i][j-1]][j-1];
            //if(par[i][j]) cout << i << " " << j << " " << par[i][j] << endl;
        }
    }
    //cout << son[4][0] << endl;
    //cout << par[2][0] << endl;
    l[0] = r[0] = 3*n;
    /*cout << par[2][0] << endl;
    cout << son[4][0] << endl;
    cout << par[9][0] << endl;
    cout << son[11][0] << endl;
    cout << par[10][0] << endl;
    cout << son[6][0] << endl;*/
    for(int t=1; t<=q; t++){
        int a, b;
        cin >> a >> b;
        if(l[a] <= l[b] && r[b] <= r[a]){
            cout << "1\n";
            continue;
        }
        if(l[b] <= l[a] && r[a] <= r[b]){
            cout << "1\n";
            continue;
        }
        if(l[a] > l[b]) swap(a, b);
        int cnt = 0;
        int res = n+5;
        /// prvo u parenta
        /// posle koliko ulazi u ciklus?
        int cik = 0;
        int x = a;
        if(son[par[a][0]][0] != a){
            x = a;
            for(int j=18; j>=1; j--){
                if(par[x][j] != 0 && !cikdole(par[x][j])){
                    cik += (1<<j);
                    x = par[x][j];
                }
            }
            if(parent(par[x][0], b) || parent(b, par[x][0])) res = min(res, cik+2);
            if(par[x][0] == b) res = min(res, cik+1);
            if(x == b) res = min(res, cik);
            if(par[x][0] != 0 && !cikgore(par[x][0])){
                cik += (1<<0);
                x = par[x][0];
                if(parent(son[x][0], b) || parent(b, son[x][0])) res = min(res, cik+2);
            }
            if(parent(x, b) || parent(b, x)) res = min(res, cik+1);
            if(parent(par[x][0], b) || parent(b, par[x][0])) res = min(res, cik+2);
            if(par[x][0] == b) res = min(res, cik+1);
            if(son[x][0] == b) res = min(res, cik+1);
            if(x == b) res = min(res, cik);
            //cout << "imamo " << x << endl;
        }
        //cout << cik << endl;
        //cout << res << " za sad "  << endl;
        int tren = 0;
        x = a;
        for(int j=18; j>=1; j--){
            if(par[x][j] != 0 && tren + (1<<j) <= cik){
                int f = par[x][j];
                if(parent(b, f)) res = min(res, tren+(1<<j)+1);
                if(b == f) res = min(res, tren+(1<<j)+1);
                if(l[f] < l[b]){
                    tren += (1<<j);
                    x = par[x][j];
                }
            }
        }
        //cout << x << "e" << tren << endl;
        int y = x;
        cnt = 0;
        while(1){
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, tren+cnt+1);
                break;
            }
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, tren+cnt+1);
                break;
            }
            if(cnt > 5) break;
        }
        cnt = 0;
        x = y;
        while(1){
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, tren+cnt+1);
                break;
            }
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, tren+cnt+1);
                break;
            }
            if(cnt > 5) break;
        }
        ///prvo u sina
        /// posle koliko ulazi u ciklus?
        cik = 0;
        x = a;
        if(par[son[a][0]][0] != a){
            x = a;
            for(int j=18; j>=1; j--){
                if(son[x][j] != 0 && !cikgore(par[x][j])){
                    cik += (1<<j);
                    x = son[x][j];
                }
            }
            if(parent(son[x][0], b) || parent(b, son[x][0])) res = min(res, cik+2);
            if(son[x][0] == b) res = min(res, cik+1);
            if(x == b) res = min(res, cik);
            if(son[x][0] != 0 && !cikdole(son[x][0])){
                cik += (1<<0);
                x = son[x][0];
                if(parent(par[x][0], b) || parent(b, par[x][0])) res = min(res, cik+2);
            }
            if(parent(x, b) || parent(b, x)) res = min(res, cik+1);
            if(parent(son[x][0], b) || parent(b, son[x][0])) res = min(res, cik+2);
            if(par[x][0] == b) res = min(res, cik+1);
            if(son[x][0] == b) res = min(res, cik+1);
            if(x == b) res = min(res, cik);
            //cout << "imamo " << x << endl;
        }
        y = x;
        cnt = 0;
        while(1){
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, tren+cnt+1);
                break;
            }
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, tren+cnt+1);
                break;
            }
            if(cnt > 5) break;
        }
        cnt = 0;
        x = y;
        while(1){
            cnt++;
            x = par[x][0];
            if(parent(x, b) || parent(b, x)){
                res = min(res, tren+cnt+1);
                break;
            }
            cnt++;
            x = son[x][0];
            if(parent(b, x) || parent(x, b)){
                res = min(res, tren+cnt+1);
                break;
            }
            if(cnt > 5) break;
        }

        if(res == n+5) res = -1;
        cout << res << "\n";
    }
    return 0;
}
/*
5 1
1 4 1 5 3 2 3 2 4 5
4 5


3 1
3 1 2 1 2 3
1 2


5 1
4 2 5 1 3 1 2 3 4 5
2 3

15 1
14 7 4 2 14 12 11 12 2 1 13 9 9 1 5 7 13 4 8 8 6 3 10 15 10 11 5 3 15 6
2 8
*/